<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Excel Institute of Professionals - TVETA & KASNEB Accredited | Thika</title>
    <meta name="description" content="Excel Institute of Professionals (E.I.P) - TVETA Registered & KASNEB Accredited. Offering CPA, CAMS, ATD, CS, CCP, CIFA, BDA courses in Thika.">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
        }

        .top-bar {
            background: linear-gradient(135deg, #1a5490 0%, #0d3a6b 100%);
            color: white;
            padding: 0.7rem 0;
            font-size: 0.9rem;
        }

        .top-bar .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .top-bar a {
            color: white;
            text-decoration: none;
            margin-left: 1.5rem;
            transition: opacity 0.3s;
        }

        .top-bar a:hover {
            opacity: 0.8;
        }

        header {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        nav {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1rem 2rem;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .logo-container {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .logo-text {
            display: flex;
            flex-direction: column;
        }

        .logo-main {
            font-size: 1.5rem;
            font-weight: bold;
            color: #1a5490;
            line-height: 1.2;
        }

        .logo-sub {
            font-size: 0.9rem;
            color: #666;
            margin-top: 0.2rem;
        }

        .accreditation {
            font-size: 1rem;
            color: #c62828;
            font-weight: 600;
        }

        .nav-links {
            display: flex;
            gap: 2rem;
            list-style: none;
            flex-wrap: wrap;
        }

        .nav-links a {
            color: #333;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }

        .nav-links a:hover {
            color: #1a5490;
        }

        .hero-slider {
            position: relative;
            height: 650px;
            overflow: hidden;
        }

        .hero-slide {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1.5s ease-in-out;
            background-size: cover;
            background-position: center;
        }

        .hero-slide::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(26, 84, 144, 0.85) 0%, rgba(13, 58, 107, 0.85) 100%);
        }

        .hero-slide.active {
            opacity: 1;
        }

        .slide1 {
            background-image: url('/images/slider/slide1.jpg');
        }

        .slide2 {
            background-image: url('/images/slider/slide2.jpg');
        }

        .slide3 {
            background-image: url('/images/slider/slide3.jpg');
        }

        .hero-content {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            text-align: center;
            color: white;
            width: 90%;
            max-width: 900px;
            z-index: 1;
        }

        .hero-badge {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            padding: 0.5rem 1.5rem;
            border-radius: 50px;
            display: inline-block;
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .hero-content h1 {
            font-size: 3.5rem;
            margin-bottom: 1rem;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
            font-weight: 700;
        }

        .hero-content p {
            font-size: 1.4rem;
            margin-bottom: 2rem;
            line-height: 1.8;
        }

        .btn-primary {
            display: inline-block;
            padding: 1rem 2.5rem;
            background: #c62828;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            font-size: 1.1rem;
            box-shadow: 0 4px 15px rgba(198, 40, 40, 0.4);
        }

        .btn-primary:hover {
            background: #a52020;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(198, 40, 40, 0.5);
        }

        .slider-controls {
            position: absolute;
            bottom: 2rem;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 1rem;
            z-index: 2;
        }

        .slider-dot {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.4);
            cursor: pointer;
            border: 2px solid white;
            transition: all 0.3s;
        }

        .slider-dot.active {
            background: white;
            width: 35px;
            border-radius: 6px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 4rem 2rem;
        }

        .section-title {
            text-align: center;
            font-size: 2.8rem;
            color: #1a5490;
            margin-bottom: 0.5rem;
            font-weight: 700;
        }

        .section-subtitle {
            text-align: center;
            font-size: 1.1rem;
            color: #666;
            margin-bottom: 3rem;
        }

        .accreditation-banner {
            background: linear-gradient(135deg, #1a5490 0%, #0d3a6b 100%);
            color: white;
            padding: 2.5rem 2rem;
            text-align: center;
        }

        .accreditation-banner h3 {
            font-size: 2rem;
            margin-bottom: 1.5rem;
            font-weight: 700;
        }

        .accreditation-items {
            display: flex;
            justify-content: center;
            gap: 3rem;
            flex-wrap: wrap;
            margin-top: 1rem;
        }

        .accreditation-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 1rem;
        }

        .accreditation-item strong {
            font-size: 1.2rem;
            color: #ffd700;
            margin-bottom: 0.5rem;
        }

        .welcome-section {
            background: #f8f9fa;
        }

        .welcome-content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 3rem;
            align-items: center;
        }

        .welcome-text h2 {
            color: #1a5490;
            margin-bottom: 1rem;
            font-size: 2rem;
        }

        .welcome-text p {
            margin-bottom: 1rem;
            line-height: 1.8;
            text-align: justify;
        }

        .welcome-image {
            background: linear-gradient(135deg, #1a5490 0%, #0d3a6b 100%);
            height: 400px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 4rem;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }

        .programs-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
        }

        .program-card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transition: all 0.3s;
            border-top: 4px solid #1a5490;
        }

        .program-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }

        .program-header {
            background: linear-gradient(135deg, #1a5490 0%, #0d3a6b 100%);
            color: white;
            padding: 1.5rem;
            text-align: center;
        }

        .program-header h3 {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
        }

        .program-content {
            padding: 1.5rem;
        }

        .program-content ul {
            list-style: none;
            padding: 0;
            margin-top: 1rem;
        }

        .program-content li {
            padding: 0.5rem 0;
            padding-left: 1.5rem;
            position: relative;
        }

        .program-content li:before {
            content: "✓";
            position: absolute;
            left: 0;
            color: #1a5490;
            font-weight: bold;
        }

        .requirements-section {
            background: linear-gradient(135deg, #c62828 0%, #a52020 100%);
            color: white;
        }

        .requirements-section .section-title,
        .requirements-section .section-subtitle {
            color: white;
        }

        .requirements-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            margin-top: 2rem;
        }

        .requirement-item {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            padding: 1.5rem;
            border-radius: 10px;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .requirement-item h4 {
            margin-bottom: 0.7rem;
            font-size: 1.2rem;
        }

        .learning-modes {
            background: #f8f9fa;
        }

        .modes-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 2rem;
            margin-top: 2rem;
        }

        .mode-card {
            background: white;
            padding: 2rem;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transition: all 0.3s;
        }

        .mode-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }

        .mode-icon {
            font-size: 3.5rem;
            margin-bottom: 1rem;
        }

        .mode-card h3 {
            color: #1a5490;
            margin-bottom: 1rem;
            font-size: 1.5rem;
        }

        .apply-section {
            background: linear-gradient(135deg, #1a5490 0%, #0d3a6b 100%);
            color: white;
        }

        .apply-section .section-title,
        .apply-section .section-subtitle {
            color: white;
        }

        .form-container {
            background: white;
            padding: 3rem;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            max-width: 900px;
            margin: 2rem auto;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #333;
        }

        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 0.8rem;
            border: 2px solid #ddd;
            border-radius: 5px;
            font-size: 1rem;
            font-family: inherit;
            transition: border-color 0.3s;
        }

        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #1a5490;
        }

        .form-group textarea {
            resize: vertical;
            min-height: 100px;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1.5rem;
        }

        .required {
            color: #c62828;
        }

        .success-message {
            display: none;
            background: #4caf50;
            color: white;
            padding: 1rem;
            border-radius: 5px;
            margin-bottom: 1.5rem;
            text-align: center;
            font-weight: 600;
        }

        footer {
            background: #1a1a1a;
            color: white;
            padding: 3rem 2rem 1rem;
        }

        .footer-content {
            max-width: 1200px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 3rem;
            margin-bottom: 2rem;
        }

        .footer-section h3 {
            color: #1a5490;
            margin-bottom: 1rem;
            font-size: 1.3rem;
        }

        .footer-section p,
        .footer-section a {
            color: #ccc;
            text-decoration: none;
            display: block;
            margin-bottom: 0.5rem;
            line-height: 1.8;
        }

        .footer-section a:hover {
            color: white;
        }

        .footer-bottom {
            text-align: center;
            padding-top: 2rem;
            border-top: 1px solid #333;
            color: #999;
        }

        @media (max-width: 768px) {
            .hero-content h1 {
                font-size: 2rem;
            }

            .hero-content p {
                font-size: 1.1rem;
            }

            .hero-slider {
                height: 500px;
            }

            .welcome-content {
                grid-template-columns: 1fr;
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .nav-links {
                gap: 1rem;
            }

            .top-bar .container {
                flex-direction: column;
                text-align: center;
            }

            .top-bar a {
                margin: 0 0.5rem;
            }

            .accreditation-items {
                flex-direction: column;
                gap: 1.5rem;
            }

            .section-title {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="top-bar">
        <div class="container">
            <div><span class="fa far-whatsapp"></span>📞  0729-517-899 / 0731-416-503 | ✉️ eipcollegethika@gmail.com</div>
            <div>
                <a href="#apply">Apply Online</a>
                <a href="#contact">Contact Us</a>
                <a href="https://www.eipcollege.ac.ke" target="_blank">Main Website</a>
            </div>
        </div>
    </div>

    <header>
        <nav>
            <div class="logo-container">
                <div class="logo-text">
                    <div class="logo-main">EXCEL INSTITUTE OF PROFESSIONALS,</div>
                    <div class="logo-sub">Thika Campus</div>
                    <div class="accreditation">TVETA Registered | CDACC,KNEC,ICM & KASNEB Accredited</div>
                </div>
            </div>
            <ul class="nav-links">
                <li><a href="#home">Home</a></li>
                <li><a href="#about">About</a></li>
                <li><a href="#programs">Programs</a></li>
                <li><a href="#requirements">Requirements</a></li>
                <li><a href="#apply">Apply Now</a></li>
                <li><a href="#contact">Contact</a></li>
            </ul>
        </nav>
    </header>

    <section id="home" class="hero-slider">
        <div class="hero-slide slide1 active">
            <div class="hero-content">
                <div class="hero-badge">🏆 TVETA & KASNEB Accredited Institution</div>
                <h1>BE A CERTIFIED PROFESSIONAL</h1>
                <p>Excel Institute of Professionals - Your Gateway to Success in Accounting, Business & ICT</p>
                <a href="#apply" class="btn-primary">Apply Now - January 2025 Intake</a>
            </div>
        </div>
        <div class="hero-slide slide2">
            <div class="hero-content">
                <div class="hero-badge">📚 Professional Qualifications</div>
                <h1>KASNEB COURSES AVAILABLE</h1>
                <p>CPA, CAMS, ATD, CS, CCP, CIFA - Build Your Professional Career with Us</p>
                <a href="#programs" class="btn-primary">Explore Our Programs</a>
            </div>
        </div>
        <div class="hero-slide slide3">
            <div class="hero-content">
                <div class="hero-badge">💻 Flexible Learning Options</div>
                <h1>OPEN & DISTANCE LEARNING</h1>
                <p>Study at Your Own Pace with Our Online Classes Available</p>
                <a href="#learning-modes" class="btn-primary">Learn More</a>
            </div>
        </div>
        <div class="slider-controls">
            <span class="slider-dot active" data-slide="0"></span>
            <span class="slider-dot" data-slide="1"></span>
            <span class="slider-dot" data-slide="2"></span>
        </div>
    </section>

    <div class="accreditation-banner">
        <h3>🎓 Registered & Fully Accredited Institution</h3>
        <div class="accreditation-items">
            <div class="accreditation-item">
                <strong>TVETA Registered</strong>
                <p>Reg NO. TVETA/PRIVATE/TVC/003/2020</p>
            </div>
            <div class="accreditation-item">
                <strong>KASNEB Fully Accredited</strong>
                <p>Reg No. KAS\F\0127</p>
            </div>
            <div class="accreditation-item">
                <strong>📍 Location</strong>
                <p>Murathe Plaza, 3rd Floor - Thika</p>
            </div>
        </div>
    </div>

    <section id="about" class="welcome-section">
        <div class="container">
            <h2 class="section-title">Welcome to Excel Institute of Professionals</h2>
            <p class="section-subtitle">Building careers through quality professional education</p>
            <div class="welcome-content">
                <div class="welcome-text">
                    <h2>About E.I.P</h2>
                    <p>Excel Institute of Professionals (E.I.P) is a premier TVETA registered and KASNEB accredited institution based in Thika, committed to providing quality professional education in Accounting, Business Management, and Information Technology.</p>
                    <p>As a fully accredited training institution (Reg NO. TVETA/PRIVATE/TVC/003/2020 and KASNEB Reg No. KAS\F\0127), we offer comprehensive programs that prepare students for professional examinations and successful careers. Our courses are recognized nationally and internationally, ensuring our graduates are competitive in the global job market.</p>
                    <p>With experienced faculty, modern computer labs, flexible learning options including open and distance learning, and a student-centered approach, we create an environment where professional excellence thrives. Located at Murathe Plaza, 3rd Floor in Thika, we are easily accessible to students from across the region.</p>
                    <p><strong>Our Vision:</strong> To be the leading professional training institution in Kenya, producing competent and ethical professionals who contribute meaningfully to national development.</p>
                    <p><strong>Our Mission:</strong> To provide quality, affordable and accessible professional education that transforms lives and builds careers.</p>
                </div>
                <div class="welcome-image">
                    🎓
                </div>
            </div>
        </div>
    </section>

    <section id="programs">
        <div class="container">
            <h2 class="section-title">KASNEB Courses & Professional Programs</h2>
            <p class="section-subtitle">Nationally recognized professional qualifications - Choose your path to success</p>
            <div class="programs-grid">
                <div class="program-card">
                    <div class="program-header">
                        <h3>📊 CAMS I - II</h3>
                        <p>Certified Accounting & Management Skills</p>
                    </div>
                    <div class="program-content">
                        <p>Foundation course for accounting and business management careers. Perfect for those starting their professional journey.</p>
                        <ul>
                            <li>Financial Accounting</li>
                            <li>Management Accounting</li>
                            <li>Business Mathematics</li>
                            <li>Office Management & IT</li>
                        </ul>
                    </div>
                </div>

                <div class="program-card">
                    <div class="program-header">
                        <h3>💼 ATD I - III</h3>
                        <p>Accounting Technicians Diploma</p>
                    </div>
                    <div class="program-content">
                        <p>Professional accounting qualification for aspiring accountants and financial managers.</p>
                        <ul>
                            <li>Financial Accounting</li>
                            <li>Cost & Management Accounting</li>
                            <li>Taxation</li>
                            <li>Principles of Auditing</li>
                        </ul>
                    </div>
                </div>

                <div class="program-card">
                    <div class="program-header">
                        <h3>📜 CS I - VI</h3>
                        <p>Certified Secretary</p>
                    </div>
                    <div class="program-content">
                        <p>Corporate governance and secretarial practice qualification for company secretaries.</p>
                        <ul>
                            <li>Company Law & Secretarial Practice</li>
                            <li>Corporate Governance</li>
                            <li>Business Communication</li>
                            <li>Boardroom Procedures</li>
                        </ul>
                    </div>
                </div>

                <div class="program-card">
                    <div class="program-header">
                        <h3>🎓 CPA</h3>
                        <p>Certified Public Accountants (Foundation - Advanced)</p>
                    </div>
                    <div class="program-content">
                        <p>Premier professional accounting qualification in Kenya and East Africa.</p>
                        <ul>
                            <li>Financial Reporting & Analysis</li>
                            <li>Advanced Auditing & Assurance</li>
                            <li>Strategic Financial Management</li>
                            <li>Public Finance & Taxation</li>
                        </ul>
                    </div>
                </div>

                <div class="program-card">
                    <div class="program-header">
                        <h3>💳 CCP I - VI</h3>
                        <p>Certified Credit Professional</p>
                    </div>
                    <div class="program-content">
                        <p>Specialized credit management and financial services qualification.</p>
                        <ul>
                            <li>Credit Management Principles</li>
                            <li>Risk Analysis & Assessment</li>
                            <li>Banking Operations & Law</li>
                            <li>Debt Management & Recovery</li>
                        </ul>
                    </div>
                </div>

                <div class="program-card">
                    <div class="program-header">
                        <h3>📈 CIFA</h3>
                        <p>Certified Investment & Financial Analyst</p>
                    </div>
                    <div class="program-content">
                        <p>Investment and financial analysis professional certification.</p>
                        <ul>
                            <li>Investment Analysis & Portfolio Management</li>
                            <li>Financial Markets & Institutions</li>
                            <li>Derivatives & Securities</li>
                            <li>Corporate Finance</li>
                        </ul>
                    </div>
                </div>

                <div class="program-card">
                    <div class="program-header">
                        <h3>🚀 Vocational Certificate</h3>
                        <p>Entrepreneurship & Innovation</p>
                    </div>
                    <div class="program-content">
                        <p>Practical business skills for entrepreneurs and business owners.</p>
                        <ul>
                            <li>Business Planning & Development</li>
                            <li>Innovation & Creativity</li>
                            <li>Marketing Strategies</li>
                            <li>Financial Management for SMEs</li>
                        </ul>
                    </div>
                </div>

                <div class="program-card">
                    <div class="program-header">
                        <h3>💻 BDA</h3>
                        <p>Business Data Analytics</p>
                    </div>
                    <div class="program-content">
                        <p>Modern data analysis for business intelligence and decision-making.</p>
                        <ul>
                            <li>Data Visualization & Reporting</li>
                            <li>Statistical Analysis</li>
                            <li>Business Intelligence Tools</li>
                            <li>Predictive Analytics</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="requirements" class="requirements-section">
        <div class="container">
            <h2 class="section-title">Basic Requirements for Application</h2>
            <p class="section-subtitle">What you need to get started with your application</p>
            <div class="requirements-grid">
                <div class="requirement-item">
                    <h4>📋 1. Identification & Academic Documents</h4>
                    <p>Copy of ID card/birth certificate & Academic certificates (KCSE, KCPE, Diploma, Degree or equivalent qualifications)</p>
                </div>
                <div class="requirement-item">
                    <h4>📸 2. Passport Photographs</h4>
                    <p>2 recent coloured passport size photos for registration and student ID</p>
                </div>
                <div class="requirement-item">
                    <h4>📄 3. Printing Papers</h4>
                    <p>2 reams of printing papers for course materials, notes and handouts</p>
                </div>
                <div class="requirement-item">
                    <h4>🔧 4. Course-Specific Materials</h4>
                    <p>Practical tools, equipments & uniform where applicable (requirements vary by program)</p>
                </div>
                <div class="requirement-item">
                    <h4>📝 5. Business Plan & Project Fee</h4>
                    <p>Business Plan and Project fee Ksh.8,000 (applicable for selected entrepreneurship and vocational courses)</p>
                </div>
                <div class="requirement-item">
                    <h4>💰 6. Instalment Payment Option</h4>
                    <p>Students paying fees in instalments must add Ksh.1,000 processing fee to their total fees</p>
                </div>
            </div>
        </div>
    </section>

    <section id="learning-modes" class="learning-modes">
        <div class="container">
            <h2 class="section-title">Flexible Learning Options</h2>
            <p class="section-subtitle">Choose the learning mode that suits your schedule and lifestyle</p>
            <div class="modes-grid">
                <div class="mode-card">
                    <div class="mode-icon">🏫</div>
                    <h3>Regular Classes</h3>
                    <p>Full-time physical classes at our Thika campus with experienced instructors, modern computer labs, and hands-on practical sessions.</p>
                </div>
                <div class="mode-card">
                    <div class="mode-icon">💻</div>
                    <h3>Open & Distance Learning (Online)</h3>
                    <p>Study remotely with online classes available for working professionals and distant learners. Flexible schedules and e-learning support.</p>
                </div>
                <div class="mode-card">
                    <div class="mode-icon">⏰</div>
                    <h3>Evening & Weekend Classes</h3>
                    <p>Convenient schedules designed for working students who want to upgrade their professional skills without interrupting their careers.</p>
                </div>
            </div>
        </div>
    </section>

    <section id="apply" class="apply-section">
        <div class="container">
            <h2 class="section-title">Student Online Application</h2>
            <p class="section-subtitle">Begin your professional journey today - January 2025 Intake Now Open!</p>
            <div class="form-container">
                <div id="successMessage" class="success-message">
                    ✓ Thank you for your application! We will review your information and contact you shortly.
                </div>
                <form id="applicationForm">
                    <h3 style="color: #1a5490; margin-bottom: 1.5rem;">Personal Information</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label>First Name <span class="required">*</span></label>
                            <input type="text" id="firstName" required>
                        </div>
                        <div class="form-group">
                            <label>Last Name <span class="required">*</span></label>
                            <input type="text" id="lastName" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Email Address <span class="required">*</span></label>
                            <input type="email" id="email" required>
                        </div>
                        <div class="form-group">
                            <label>Phone Number <span class="required">*</span></label>
                            <input type="tel" id="phone" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Date of Birth <span class="required">*</span></label>
                            <input type="date" id="dob" required>
                        </div>
                        <div class="form-group">
                            <label>Gender <span class="required">*</span></label>
                            <select id="gender" required>
                                <option value="">Select Gender</option>
                                <option value="male">Male</option>
                                <option value="female">Female</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Residential Address <span class="required">*</span></label>
                        <input type="text" id="address" required>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>County <span class="required">*</span></label>
                            <input type="text" id="county" required>
                        </div>
                        <div class="form-group">
                            <label>National ID / Passport Number <span class="required">*</span></label>
                            <input type="text" id="idNumber" required>
                        </div>
                    </div>

                    <h3 style="color: #1a5490; margin: 2rem 0 1.5rem;">Academic Information</h3>

                    <div class="form-group">
                        <label>Program of Interest <span class="required">*</span></label>
                        <select id="program" required>
                            <option value="">Select a Program</option>
                            <option value="cams">CAMS I - II</option>
                            <option value="atd">ATD I - III</option>
                            <option value="cs">CS I - VI</option>
                            <option value="cpa">CPA (Foundation - Advanced)</option>
                            <option value="ccp">CCP I - VI</option>
                            <option value="cifa">CIFA</option>
                            <option value="vocational">Vocational Certificate - Entrepreneurship & Innovation</option>
                            <option value="bda">Business Data Analytics (BDA)</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Highest Education Level <span class="required">*</span></label>
                        <select id="education" required>
                            <option value="">Select Education Level</option>
                            <option value="kcse">KCSE</option>
                            <option value="kcpe">KCPE</option>
                            <option value="diploma">Diploma</option>
                            <option value="certificate">Certificate</option>
                            <option value="degree">Bachelor's Degree</option>
                            <option value="masters">Master's Degree</option>
                            <option value="other">Other</option>
                        </select>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Year Completed</label>
                            <input type="number" id="yearCompleted" min="1980" max="2025">
                        </div>
                        <div class="form-group">
                            <label>Grade / Score Achieved</label>
                            <input type="text" id="grade" placeholder="e.g., B+, Distinction">
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Preferred Learning Mode <span class="required">*</span></label>
                        <select id="learningMode" required>
                            <option value="">Select Learning Mode</option>
                            <option value="regular">Regular Classes (Full-time)</option>
                            <option value="online">Open & Distance Learning (Online)</option>
                            <option value="evening">Evening & Weekend Classes</option>
                        </select>
                    </div>

                    <h3 style="color: #1a5490; margin: 2rem 0 1.5rem;">Additional Information</h3>

                    <div class="form-group">
                        <label>How did you hear about Excel Institute?</label>
                        <select id="source">
                            <option value="">Select Option</option>
                            <option value="website">Website</option>
                            <option value="facebook">Facebook</option>
                            <option value="social-media">Other Social Media</option>
                            <option value="friend">Friend/Family Referral</option>
                            <option value="poster">Poster/Flyer</option>
                            <option value="other">Other</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Tell us why you want to join Excel Institute of Professionals</label>
                        <textarea id="message" placeholder="Share your career goals and aspirations..."></textarea>
                    </div>

                    <button type="submit" class="btn-primary" style="width: 100%; font-size: 1.1rem; margin-top: 1rem;">Submit Application</button>
                </form>
            </div>
        </div>
    </section>

    <footer id="contact">
        <div class="footer-content">
            <div class="footer-section">
                <h3>About Excel Institute of Professionals</h3>
                <p><strong>E.I.P - Thika Campus</strong></p>
                <p>TVETA Registered (Reg NO. TVETA/PRIVATE/TVC/003/2020)</p>
                <p>KASNEB Fully Accredited (Reg No. KAS\F\0127)</p>
                <p style="margin-top: 1rem;">Excellence in professional education. Building careers through quality training in Accounting, Business & ICT.</p>
            </div>
            <div class="footer-section">
                <h3>Quick Links</h3>
                <a href="#about">About Us</a>
                <a href="#programs">Our Programs</a>
                <a href="#requirements">Application Requirements</a>
                <a href="#learning-modes">Learning Options</a>
                <a href="#apply">Apply Online</a>
            </div>
            <div class="footer-section">
                <h3>Contact Information</h3>
                <p><strong>📍 Location:</strong></p>
                <p>Murathe Plaza, 3rd Floor</p>
                <p>Thika Town, Kenya</p>
                <p style="margin-top: 1rem;"><strong>📞 Phone:</strong></p>
                <p>0729-517-899</p>
                <p>0731-416-503</p>
                <p>067-41548</p>
                <p style="margin-top: 1rem;"><strong>✉️ Email:</strong></p>
                <p>eipcollegethika@gmail.com</p>
                <p style="margin-top: 1rem;"><strong>🕒 Office Hours:</strong></p>
                <p>Monday - Friday: 8:00 AM - 5:00 PM</p>
                <p>Saturday: 9:00 AM - 1:00 PM</p>
            </div>
            <div class="footer-section">
                <h3>Connect With Us</h3>
                <p>Stay updated with Excel Institute</p>
                <a href="https://www.facebook.com/share/p/1MkonaSfE3/" target="_blank">📘 Facebook</a>
                <a href="https://www.eipcollege.ac.ke" target="_blank">🌐 Main Website</a>
                <a href="mailto:eipcollegethika@gmail.com">✉️ Email Us</a>
                <p style="margin-top: 1rem;"><strong>Mobile Money Payments:</strong></p>
                <p>M-PESA Paybill: [Contact for details]</p>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; 2025 Excel Institute of Professionals. All rights reserved.</p>
            <p>TVETA Registered |CDACC,KNEC,ICM & KASNEB Accredited | Empowering Future Professionals</p>
        </div>
    </footer>

    <script>
        // Hero Slider
        let currentSlide = 0;
        const slides = document.querySelectorAll('.hero-slide');
        const dots = document.querySelectorAll('.slider-dot');
        const totalSlides = slides.length;

        function showSlide(index) {
            slides.forEach(slide => slide.classList.remove('active'));
            dots.forEach(dot => dot.classList.remove('active'));
            
            slides[index].classList.add('active');
            dots[index].classList.add('active');
        }

        function nextSlide() {
            currentSlide = (currentSlide + 1) % totalSlides;
            showSlide(currentSlide);
        }

        let slideInterval = setInterval(nextSlide, 5000);

        dots.forEach((dot, index) => {
            dot.addEventListener('click', () => {
                currentSlide = index;
                showSlide(currentSlide);
                clearInterval(slideInterval);
                slideInterval = setInterval(nextSlide, 5000);
            });
        });

        // Application Form
        document.getElementById('applicationForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = {
                firstName: document.getElementById('firstName').value,
                lastName: document.getElementById('lastName').value,
                email: document.getElementById('email').value,
                phone: document.getElementById('phone').value,
                dob: document.getElementById('dob').value,
                gender: document.getElementById('gender').value,
                address: document.getElementById('address').value,
                county: document.getElementById('county').value,
                idNumber: document.getElementById('idNumber').value,
                program: document.getElementById('program').value,
                education: document.getElementById('education').value,
                yearCompleted: document.getElementById('yearCompleted').value,
                grade: document.getElementById('grade').value,
                learningMode: document.getElementById('learningMode').value,
                source: document.getElementById('source').value,
                message: document.getElementById('message').value
            };
            
            console.log('Application submitted:', formData);
            
            // Show success message
            document.getElementById('successMessage').style.display = 'block';
            document.getElementById('applicationForm').reset();
            
            // Hide success message after 5 seconds
            setTimeout(() => {
                document.getElementById('successMessage').style.display = 'none';
            }, 5000);
            
            // Scroll to top of form
            window.scrollTo({
                top: document.getElementById('apply').offsetTop - 100,
                behavior: 'smooth'
            });
        });

        // Smooth Scrolling for navigation links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
    </script>
</body>
</html>